#include "cvbackgrounddetect.hpp"
#include "cvmainwindow.hpp"
#include "cvetc.hpp"

Detector::Detector(){
    const int varThreshold = 80;
    const bool bShadowDetection = false;
    const int history = 800;
    simpleAlgoObj.bg = cv::BackgroundSubtractorMOG2(history,varThreshold,bShadowDetection);
}

QPair<cv::Mat,cv::Mat> Detector::simplealgorithm(const cv::Mat frame){

    cv::Mat result;
    frame.copyTo(result);

    simpleAlgoObj.bg.operator ()(result,simpleAlgoObj.fore);
    simpleAlgoObj.bg.getBackgroundImage(simpleAlgoObj.back);

    cv::Mat tmp;
    simpleAlgoObj.fore.copyTo(tmp);

    cv::erode(simpleAlgoObj.fore,simpleAlgoObj.fore,cv::Mat());
    cv::dilate(simpleAlgoObj.fore,simpleAlgoObj.fore,cv::Mat());
    cv::findContours(simpleAlgoObj.fore,simpleAlgoObj.contours,CV_RETR_EXTERNAL,CV_CHAIN_APPROX_NONE);
    cv::drawContours(result,simpleAlgoObj.contours,-1,cv::Scalar(0,0,255),2);

    return thresh_callback(tmp,frame);
}

QPair<cv::Mat,cv::Mat> Detector::pbasAlgorithm(const cv::Mat frame)
{

    cv::Mat result;
    frame.copyTo(result);


    cv::Mat bluredImage;
    cv::Mat pbasResult;
    cv::GaussianBlur(frame, bluredImage, cv::Size(9,9), 1.5);

    std::vector<cv::Mat> rgbChannels;
    cv::split(bluredImage, rgbChannels);

    //m_pbasResult.copyTo(output);
    pbasAlgoObj.channel1.setInputMatrix(&rgbChannels[0]);
    pbasAlgoObj.channel2.setInputMatrix(&rgbChannels[1]);
    pbasAlgoObj.channel3.setInputMatrix(&rgbChannels[2]);

    // run all threads
    pbasAlgoObj.channel1.start();
    pbasAlgoObj.channel2.start();
    pbasAlgoObj.channel3.start();
    pbasAlgoObj.channel1.wait();
    pbasAlgoObj.channel2.wait();
    pbasAlgoObj.channel3.wait();

    // combine results
    cv::bitwise_or(pbasAlgoObj.channel3.getOutputMatrix(), pbasAlgoObj.channel1.getOutputMatrix(),pbasResult);
    cv::bitwise_or(pbasResult, pbasAlgoObj.channel2.getOutputMatrix(), pbasResult);

    cv::erode(pbasResult,pbasResult,cv::Mat(),cv::Point(-1,-1),3);
    cv::dilate(pbasResult,pbasResult,cv::Mat(),cv::Point(-1,-1),3);
    cv::medianBlur(pbasResult, pbasResult, 5);
    cv::Mat tmp;

    pbasResult.copyTo(tmp);
    cv::findContours(pbasResult,pbasAlgoObj.contours,CV_RETR_LIST,CV_CHAIN_APPROX_NONE);


    std::vector<std::vector<cv::Point> >contours;
    int minContourPointsAllowed = 20;

    for (size_t i=0; i<pbasAlgoObj.contours.size(); i++)
    {
        int contourSize = (int) pbasAlgoObj.contours[i].size();
        if (contourSize > minContourPointsAllowed)
        {
            contours.push_back(pbasAlgoObj.contours[i]);
        }
    }

    pbasAlgoObj.contours = contours;
    //cv::drawContours(pbasResult,pbasAlgoObj.contours,-1,cv::Scalar(0,0,255),2);

    rgbChannels.at(0).release();
    rgbChannels.at(1).release();
    rgbChannels.at(2).release();
    rgbChannels.clear();

    return thresh_callback(tmp,frame);
}

QPair<cv::Mat,cv::Mat> Detector::combinedAlgorithm(const cv::Mat frame)
{
    cv::Mat mat1 = pbasAlgorithm(frame).second;
    cv::Mat mat2 = simplealgorithm(frame).second;

    cvETC::writeDebugInfoImage(frame);
    cvETC::writeDebugInfoImage(mat1);
    cvETC::writeDebugInfoImage(mat2);

    cv::Mat result;
    cv::bitwise_and(mat1,mat2,result);

    cvETC::writeDebugInfoImage(result);

    cv::medianBlur(result, result, 5);

    cvETC::writeDebugInfoImage(result);

    return thresh_callback(result,frame);
}

QPair<cv::Mat,cv::Mat> Detector::combinedAlgorithmIF(const cv::Mat frame)
{
    cv::Mat subImage;
    frame.copyTo(subImage);

    cv::Mat mat1 = pbasAlgorithm(frame).second;
    cv::Mat mat2 = simplealgorithm(frame).second;

    cv::Mat result,result2,tmp;
    cv::bitwise_and(mat1,mat2,result);

    if(lastFrame.empty()) frame.copyTo(lastFrame);
    else
    {
        subImage = frame-lastFrame;
        frame.copyTo(lastFrame);

       cvtColor( subImage, subImage, CV_RGB2GRAY );
       cv::adaptiveThreshold(subImage, subImage,255,cv::ADAPTIVE_THRESH_GAUSSIAN_C, CV_THRESH_BINARY,15,-5);
       cv::bitwise_or(result,subImage,result);
    }


    cv::medianBlur(result, result, 5);


    frame.copyTo(result2);
    result.copyTo(tmp);

    std::vector<std::vector<cv::Point> >contours;
    cv::findContours(result,contours,CV_RETR_LIST,CV_CHAIN_APPROX_NONE);
    cv::drawContours(result2,contours,-1,cv::Scalar(0,0,255),2);

    return thresh_callback(tmp,frame);
}

/** @function thresh_callback */
 QPair<cv::Mat,cv::Mat> Detector::thresh_callback(const cv::Mat img, const cv::Mat frame)
{
    cv::Mat tmp,tmp2;
    frame.copyTo(tmp);
    img.copyTo(tmp2);

    cv::Mat saveImg;
    cv::cvtColor(img, saveImg, CV_GRAY2BGR);

    cv::Mat threshold_output;
    std::vector<std::vector<cv::Point> > contours;


    /// Detect edges using Threshold
    cv::threshold( tmp2, threshold_output, 100, 255, cv::THRESH_BINARY );
    /// Find contours
    cv::findContours(tmp2,contours,CV_RETR_EXTERNAL,CV_CHAIN_APPROX_NONE);

    /// Approximate contours to polygons + get bounding rects and circles
    std::vector<std::vector<cv::Point> > contours_poly( contours.size() );
    std::vector<cv::Rect> boundRect( contours.size() );

    for( int i = 0; i < contours.size(); i++ )
    { approxPolyDP( cv::Mat(contours[i]), contours_poly[i], 3, true );
        boundRect[i] = boundingRect( cv::Mat(contours_poly[i]) );
    }

    cv::Mat drawing = cv::Mat::zeros( img.size(), CV_8UC3 );

    for( int i = 0; i< contours.size(); i++ )
    {
        cv::Rect temp = boundRect[i];

        if(temp.area() >= 42)
        {
            cv::Scalar color = cv::Scalar( 0,0,255);

            if(CVMainWindow::showBoundingBox)
            {
                //cv::floodFill( tmp, cv::Point(i, tmp.rows-1), 0, 0, 10, 10);
                cv::rectangle( tmp, boundRect[i].tl(), boundRect[i].br(), color, 2, 8, 0 );
            }

            if(CVMainWindow::showContours)
            {
                cv::drawContours( tmp, contours_poly, i, color, 1, 8, std::vector<cv::Vec4i>(), 0, cv::Point() );
            }

            cv::Mat roi(drawing(temp));
            cv::Mat orig_roi(saveImg(temp));
            orig_roi.copyTo(roi);
        }

    }

    cv::Mat filled =  cvETC::fillImage(drawing);
    cvETC::writeDebugInfoImage(filled);
    cvETC::writeDebugInfoImage(tmp);

    return QPair<cv::Mat,cv::Mat> (tmp,filled);
}
