#ifndef CVBACKGROUNDDETECT_H
#define CVBACKGROUNDDETECT_H

#include <opencv2/opencv.hpp>
#include <QImage>
#include <vector>
#include "cvfilemanager.hpp"
#include <iostream>
#include <QPair>
#include "cvpbas.hpp"

class Detector
{
private:

    struct{
        cv::Mat back;
        cv::Mat fore;
        std::vector<std::vector<cv::Point> > contours;
        cv::BackgroundSubtractorMOG2 bg;
    }simpleAlgoObj;

    struct{
        cvPBASThread channel1;
        cvPBASThread channel2;
        cvPBASThread channel3;
        std::vector<std::vector<cv::Point> > contours;
    }pbasAlgoObj;

      QPair<cv::Mat,cv::Mat> thresh_callback(const cv::Mat img, const cv::Mat frame);

      cv::Mat lastFrame;



public:
    Detector();
    QPair<cv::Mat,cv::Mat> simplealgorithm(const cv::Mat frame);
    QPair<cv::Mat,cv::Mat> pbasAlgorithm(const cv::Mat frame);
    QPair<cv::Mat,cv::Mat> combinedAlgorithm(const cv::Mat frame);
    QPair<cv::Mat,cv::Mat> combinedAlgorithmIF(const cv::Mat frame);

};

#endif // CVBACKGROUNDDETECT_H
