#include "cvetc.hpp"


QStringList cvETC::getFileNamesDialog(QWidget *parent,int fileTypes, QString path)
{
    QString filter = "";
    if ( fileTypes & jpgFiles ) {
        filter += "JPEG (*.jpg *.jpeg);;";
    }

    if ( fileTypes & pngFiles ) {
        filter  += "PNG (*.png);;";
    }

    if ( fileTypes & tiffFiles ) {
        filter  += "TIFF (*.tif *.tiff);;";
    }



    return QFileDialog::getOpenFileNames(parent,"Datei(en) öffnen",path,filter+="All files (*.*)",0,0);

}

void cvETC::addRowToTagView(QTableWidget *table, const QString tag,const QString detail)
{
    int rowCount = table->rowCount();
    table->insertRow(rowCount);
    if(!detail.isEmpty())
    {
        QTableWidgetItem *qtwi1 = new QTableWidgetItem(tag);
        QTableWidgetItem *qtwi2 = new QTableWidgetItem(detail);
        table->setItem(rowCount, 0, qtwi1);
        table->setItem(rowCount, 1, qtwi2);

        qtwi1->setToolTip(tag);
        qtwi2->setToolTip(detail);
    }
    else
    {
        QTableWidgetItem *qtwi = new QTableWidgetItem(tag);
        table->setItem(rowCount, 0, qtwi);

        QFont font;
        font.setBold(true);

        qtwi->setFont(font);
        qtwi->setToolTip(tag);
        table->setSpan(rowCount,0,1,2);
    }
}

void cvETC::writeDebugInfoImage(cv::Mat output)
{
    static int counter=1;
    std::string s;
    std::stringstream out;
    out << counter++;
    s = out.str();

    std::string fileName = "C:/Users/Stefan/Desktop/ergebnis/frame";
                fileName+= s;
                fileName+= ".jpg";

    cv::imwrite(fileName, output );
}

void cvETC::writeImageToFile(cv::Mat output, cvFile file){

    cv::Mat result;
    output.copyTo(result);

    QString dir = file.getFileInfo().dir().absolutePath() +  "/result/";
    if(!QDir(dir).exists())
    {
         QDir().mkdir(dir);
    }

    dir += CVMainWindow::selectedAlgorithm + "/";

    if(!QDir(dir).exists())
    {
         QDir().mkdir(dir);
    }

    std::string fileName = dir.toUtf8().constData(); // dir
                fileName+= "b";
                fileName+= file.getFileInfo().baseName().toUtf8().constData(); // fileName
                fileName+= ".jpg"; // fileExtension

    cv::imwrite( fileName, result );
}

cv::Mat cvETC::fillImage(cv::Mat input){
    cv::Mat image;
    cv::cvtColor(input, image, CV_BGR2GRAY );
    cv::Mat image_thresh;
    cv::threshold(image, image_thresh, 125, 255, cv::THRESH_BINARY);

    // Loop through the border pixels and if they're black, floodFill from there
    cv::Mat mask;
    image_thresh.copyTo(mask);
    for (int i = 0; i < mask.cols; i++) {
        if (mask.at<char>(0, i) == 0) {
            cv::floodFill(mask, cv::Point(i, 0), 255, 0, 10, 10);
        }
        if (mask.at<char>(mask.rows-1, i) == 0) {
            cv::floodFill(mask, cv::Point(i, mask.rows-1), 255, 0, 10, 10);
        }
    }
    for (int i = 0; i < mask.rows; i++) {
        if (mask.at<char>(i, 0) == 0) {
            cv::floodFill(mask, cv::Point(0, i), 255, 0, 10, 10);
        }
        if (mask.at<char>(i, mask.cols-1) == 0) {
            cv::floodFill(mask, cv::Point(mask.cols-1, i), 255, 0, 10, 10);
        }
    }


    // Compare mask with original.
    cv::Mat newImage;
    image.copyTo(newImage);
    for (int row = 0; row < mask.rows; ++row) {
        for (int col = 0; col < mask.cols; ++col) {
            if (mask.at<char>(row, col) == 0) {
                newImage.at<char>(row, col) = 255;
            }
        }
    }

    return newImage;
}
