#ifndef CVETC_H
#define CVETC_H

#include <QApplication>
#include <QFileDialog>
#include <QObject>
#include <QTableWidget>
#include "opencv2/core/core.hpp"
#include "cvmainwindow.hpp"

namespace cvETC
{

static bool activate_resize = false;

/**
 * @brief The FileTypes Filter-Flags fuer Datei-Dialog
 */
enum FileTypes {
    /// jpgFiles
    jpgFiles = 1 << 0,
    /// pngFiles
    pngFiles = 1 << 1,
    /// tiffFiles
    tiffFiles = 1 << 2
};

/**
 * @brief cvETC::getFileNamesDialog
 * @param parent QWidget, welches nach Abschluss der Methode wieder angezeigt wird.
 * @param fileTypes Filter fuer Dateidialog z.B. cvETC::jpgFiles | cvETC::pngFiles
 * @return Gibt eine Liste mit den absoluten Dateipfaden der ausgewaehlten Dateien zurueck
 */
QStringList getFileNamesDialog(QWidget *parent,int fileTypes,QString path="/");

/**
 * @brief cvETC::addRowToTagView
 * @param table The table, which will be filled
 * @param tag The tag for a property. If detail is NULL, it can be used as an header
 * @param detail represents the value of a property
 * @attention column count of the table must be "2"
 */
void addRowToTagView(QTableWidget *table, const QString tag,const QString detail);
void writeImageToFile(cv::Mat output, cvFile file);
cv::Mat fillImage(cv::Mat input);

void writeDebugInfoImage(cv::Mat output);
}


#endif // CVETC_H
