#include "cvfilemanager.hpp"

#include <QProgressDialog>
#include <QDebug>
#include <QApplication>

cvFileManager::cvFileManager(QWidget * parent, QStringList fileListItems)
{
    this->parent = parent;

    QProgressDialog progress("Bilder werden geladen", "Laden abbrechen", 0, fileListItems.size()+1, parent);
    progress.setWindowModality(Qt::WindowModal);

    int count = 0;
    for ( QStringList::Iterator it = fileListItems.begin(); it != fileListItems.end(); ++it )
    {
        QApplication::processEvents();
        progress.setValue(count);
        count++;

        if (progress.wasCanceled())
            break;

        this->fileList.push_back(cvFile(*it));
    }

    progress.setValue(fileListItems.size()+1);
}

QStringList cvFileManager::getAllBaseNames(void) const
{
    QStringList liste;

    for (std::vector<cvFile>::const_iterator ci = fileList.begin(); ci != fileList.end(); ++ci)
    {
        cvFile file = (*ci);
        liste << file.getFileInfo().baseName();
    }
    return liste;
}

#include "cvmainwindow.hpp"
cvFile::cvFile(QString filePath)
{
    fileInfo = QFileInfo(filePath);

    if(!CVMainWindow::delayLoading)
    {
        cvImage = cv::imread(fileInfo.absoluteFilePath().toLocal8Bit().constData(), true);
    }
}

cvFile cvFileManager::getFileForIndex(int index)
{
    return fileList[index];
}

cv::Mat cvFile::getcvImage()
{
    if(CVMainWindow::delayLoading)
    {
        cvImage = cv::imread(fileInfo.absoluteFilePath().toLocal8Bit().constData(), true);
        return cvImage;
    }

    return cvImage;
}
