#ifndef CVFILEMANAGER_HPP
#define CVFILEMANAGER_HPP

#include <QDir>
#include <QFileInfo>
#include <QWidget>
#include <vector>
#include <QImage>
#include <opencv2/opencv.hpp>
/**
 * @brief The cvFile class
 * @title cvFile Class containing several Information about an Image-File
 */

class cvFile
{
private:
    QFileInfo fileInfo;
    cv::Mat cvImage;

public:
    cvFile(){}
    cvFile(QString filePath);
    QFileInfo getFileInfo(void) const { return fileInfo; }

    void setFileInfo(QFileInfo fileInfo) { this->fileInfo = fileInfo;}
    cv::Mat getcvImage(void);
    void setcvImage(cv::Mat cvImage) { this->cvImage = cvImage;}
};

class cvFileManager
{

private:
    QDir directory;
    std::vector<cvFile> fileList;
    int currentListPosition;
    QWidget *parent;

public:
    cvFileManager(){}
    cvFileManager(QWidget * parent, QStringList fileListItems);
    QStringList getAllBaseNames(void) const;
    cvFile getFileForIndex(int index);
    int getNumOfFiles(){return (int) fileList.size();}
    int getCurrentListPosition(){return currentListPosition;}
    void setCurrentListPosition(int pos) {currentListPosition = pos;}
};



#endif // CVFILEMANAGER_HPP
