#include "cvmainwindow.hpp"
#include "ui_cvmainwindow.h"


QString CVMainWindow::selectedAlgorithm;
bool CVMainWindow::delayLoading;
bool CVMainWindow::exportresults;
bool CVMainWindow::showBoundingBox;
bool CVMainWindow::showContours;

CVMainWindow::CVMainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::CVMainWindow)
{
    ui->setupUi(this);

    ui->qpb_nav_up->setEnabled(false);
    ui->qpb_nav_down->setEnabled(false);
    ui->qpb_nav_play_pause->setEnabled(false);
    ui->qpb_nav_stop->setEnabled(false);
    ui->qpb_nav_loop->setEnabled(false);

    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(timerUpdate()));
    detector = new Detector();

    qcb_methodChooser = new QComboBox;
    qcb_methodChooser->addItem("PBAS ^ MOG2");
    qcb_methodChooser->addItem("(PBAS ^ MOG2) v IF");
    qcb_methodChooser->addItem("BackgroundSubtractorMOG2");
    qcb_methodChooser->addItem("PBAS");
    qcb_methodChooser->addItem("- None -");
    ui->mainToolBar->addWidget(qcb_methodChooser);

    showBoundingBox=true;
    delayLoading = true;
}

CVMainWindow::~CVMainWindow()
{
    delete[] timer;
    delete[] detector;
    delete[] qcb_methodChooser;
    delete[] ui;
}

void CVMainWindow::on_actionBeenden_triggered()
{
    exit(0);
}

void CVMainWindow::closeEvent(QCloseEvent *event){
    (void) event;
    exit(0);
}

void CVMainWindow::on_action_ffnen_triggered()
{
    QSettings settings(QSettings::IniFormat, QSettings::UserScope,
                       "iVision", "iVision");

    timer->stop();
    ui->qlw_files->clear();
    this->fileManager = cvFileManager(this,cvETC::getFileNamesDialog(this,cvETC::jpgFiles | cvETC::pngFiles | cvETC::tiffFiles, settings.value("DirPath","/").toString()));
    ui->qlw_files->addItems(this->fileManager.getAllBaseNames());

    if(this->fileManager.getNumOfFiles()!=0)
    {
        detector = new Detector();

        settings.setValue("DirPath",this->fileManager.getFileForIndex(0).getFileInfo().dir().absolutePath());

        ui->qpb_nav_down->setEnabled(true);
        ui->qpb_nav_play_pause->setEnabled(true);
        ui->qpb_nav_loop->setEnabled(true);

        ui->qlw_files->setCurrentRow(0);
    }
    else
    {
        ui->qpb_nav_down->setEnabled(false);
        ui->qpb_nav_play_pause->setEnabled(false);
        ui->qpb_nav_loop->setEnabled(false);
    }
}


void CVMainWindow::on_qlw_files_currentRowChanged(int currentRow)
{
    if(currentRow<0) return;

    QTime ownTimer;
    ownTimer.restart();

    QFileInfo selectedFile = this->fileManager.getFileForIndex(currentRow).getFileInfo();

    ui->qtw_PropertyBox->clear();
    ui->qtw_PropertyBox->setRowCount(0);

    cv::Mat out1,out2;

        if(this->qcb_methodChooser->currentText() == "- None -")
        {
            cv::Mat output = this->fileManager.getFileForIndex(currentRow).getcvImage();
            output.copyTo(out1);
            output.copyTo(out2);
        }
        else  if(this->qcb_methodChooser->currentText() == "PBAS")
        {
            QPair<cv::Mat,cv::Mat> output = detector->pbasAlgorithm(this->fileManager.getFileForIndex(currentRow).getcvImage());
            output.first.copyTo(out1);
            output.second.copyTo(out2);

            selectedAlgorithm = "PBAS";
            if(exportresults){
                cvETC::writeImageToFile(output.second, this->fileManager.getFileForIndex(currentRow));
            }
        }
        else  if(this->qcb_methodChooser->currentText() == "PBAS ^ MOG2")
        {
            QPair<cv::Mat,cv::Mat> output = detector->combinedAlgorithm(this->fileManager.getFileForIndex(currentRow).getcvImage());
            output.first.copyTo(out1);
            output.second.copyTo(out2);

            selectedAlgorithm = "PBAS_MOG2";
            if(exportresults){
                cvETC::writeImageToFile(output.second, this->fileManager.getFileForIndex(currentRow));
            }
        }
        else  if(this->qcb_methodChooser->currentText() == "(PBAS ^ MOG2) v IF")
        {
            QPair<cv::Mat,cv::Mat> output = detector->combinedAlgorithmIF(this->fileManager.getFileForIndex(currentRow).getcvImage());
            output.first.copyTo(out1);
            output.second.copyTo(out2);

            selectedAlgorithm = "PBAS_MOG2_IF";
            if(exportresults){
                cvETC::writeImageToFile(output.second, this->fileManager.getFileForIndex(currentRow));
            }
        }

        else
        {
            QPair<cv::Mat,cv::Mat> output = detector->simplealgorithm(this->fileManager.getFileForIndex(currentRow).getcvImage());
            output.first.copyTo(out1);
            output.second.copyTo(out2);

            selectedAlgorithm = "MOG2";
            if(exportresults){
                cvETC::writeImageToFile(output.second, this->fileManager.getFileForIndex(currentRow));
            }
        }

    std::pair<float,float> scaleFact;

    scaleFact.first = 240.f/out1.size().height;
    scaleFact.second = 320.f/out1.size().width;
    cv::resize(out1, out1, cv::Size(), scaleFact.first, scaleFact.second);
    cv::resize(out2, out2, cv::Size(), scaleFact.first, scaleFact.second);
    ui->qw_imageView->showImage(out1);
    ui->qw_imageView2->showImage(out2);


    QString filesize;
    float size = selectedFile.size();

    size = size/1024/1024;

    filesize.setNum(size,'f',2);
    cvETC::addRowToTagView(ui->qtw_PropertyBox,"Filename",selectedFile.baseName());
    cvETC::addRowToTagView(ui->qtw_PropertyBox,"FileSize",filesize+" MB");

    QString number;
    number.setNum((float)ownTimer.elapsed()/1000,'g',6);
    cvETC::addRowToTagView(ui->qtw_PropertyBox,"Performance","");
    cvETC::addRowToTagView(ui->qtw_PropertyBox,"Elapsed Time (sec)",number);

    if(currentRow==0)
    {
        ui->qpb_nav_down->setEnabled(true);
        ui->qpb_nav_up->setEnabled(false);
    }
    else if(currentRow==ui->qlw_files->count()-1)
    {
        ui->qpb_nav_down->setEnabled(false);
        ui->qpb_nav_up->setEnabled(true);
    }
    else
    {
        ui->qpb_nav_down->setEnabled(true);
        ui->qpb_nav_up->setEnabled(true);
    }


    this->fileManager.setCurrentListPosition(currentRow);
}

#pragma region NavigationMethods

void CVMainWindow::on_qpb_nav_up_clicked()
{
    int pos = this->fileManager.getCurrentListPosition();
    this->fileManager.setCurrentListPosition(--pos);
    ui->qlw_files->setCurrentRow(pos);
}

void CVMainWindow::on_qpb_nav_down_clicked()
{
    int pos = this->fileManager.getCurrentListPosition();
    this->fileManager.setCurrentListPosition(++pos);
    ui->qlw_files->setCurrentRow(pos);
}

void CVMainWindow::on_qpb_nav_play_pause_toggled(bool checked)
{
    ui->qpb_nav_stop->setEnabled(true);
    if(checked)
    {
        this->qcb_methodChooser->setEnabled(false);
        timer->start((1000/ ui->qsb_frameRate->value()));
    }
    else
    {
        timer->stop();
        this->qcb_methodChooser->setEnabled(true);
    }
}

void CVMainWindow::on_qpb_nav_stop_clicked()
{
    ui->qpb_nav_play_pause->setChecked(false);
    ui->qpb_nav_stop->setEnabled(false);
    this->qcb_methodChooser->setEnabled(true);
}

void CVMainWindow::on_qsb_frameRate_valueChanged(int arg1)
{
    timer->setInterval((1000/ arg1));
}

#pragma endregion NavigationMethods

void CVMainWindow::timerUpdate()
{
    int pos = this->fileManager.getCurrentListPosition();

    if(pos<this->fileManager.getNumOfFiles()-1)
    {
        this->fileManager.setCurrentListPosition(++pos);
        ui->qlw_files->setCurrentRow(pos);
    }
    else if(ui->qpb_nav_loop->isChecked())
    {
        this->fileManager.setCurrentListPosition(0);
        ui->qlw_files->setCurrentRow(0);
    }
    else
    {
        timer->stop();
        ui->qpb_nav_play_pause->setChecked(false);
        ui->qpb_nav_stop->setEnabled(false);
    }
}

void CVMainWindow::on_actionDelayLoading_triggered(bool checked)
{
    if(checked) delayLoading=true;
    else delayLoading=false;
}

void CVMainWindow::on_actionErgebnisbilder_exportieren_triggered(bool checked)
{
    if(checked) exportresults=true;
    else exportresults=false;
}

void CVMainWindow::on_actionBounding_Box_toggled(bool arg1)
{
    showBoundingBox = arg1;
}


void CVMainWindow::on_actionContour_toggled(bool arg1)
{
    showContours = arg1;
}
