#ifndef CVMAINWINDOW_H
#define CVMAINWINDOW_H

#include <QMainWindow>
#include <QFileSystemModel>
#include <QFileDialog>
#include <QDebug>
#include <QTimer>
#include <QFileInfo>
#include <QComboBox>
#include <QSettings>
#include <QPair>
#include <QTime>

#include "cvbackgrounddetect.hpp"
#include "cvetc.hpp"
#include "cvfilemanager.hpp"

namespace Ui {

class CVMainWindow;
}

class CVMainWindow : public QMainWindow
{
    Q_OBJECT
    
protected:
     void closeEvent(QCloseEvent *event);

public:
    explicit CVMainWindow(QWidget *parent = 0);
    ~CVMainWindow();
    static QString selectedAlgorithm;
    static bool delayLoading;
    static bool exportresults;

    static bool showBoundingBox;
    static bool showContours;


private slots:
    void on_actionBeenden_triggered();

    void on_action_ffnen_triggered();

    void on_qlw_files_currentRowChanged(int currentRow);

    void on_qpb_nav_up_clicked();

    void on_qpb_nav_down_clicked();

    void on_qpb_nav_play_pause_toggled(bool checked);

    void on_qpb_nav_stop_clicked();

    void timerUpdate();

    void on_qsb_frameRate_valueChanged(int arg1);

    void on_actionDelayLoading_triggered(bool checked);

    void on_actionErgebnisbilder_exportieren_triggered(bool checked);

    void on_actionBounding_Box_toggled(bool arg1);

    void on_actionContour_toggled(bool arg1);

private:
    Ui::CVMainWindow *ui;
    cvFileManager fileManager;
    QTimer *timer;
    QComboBox *qcb_methodChooser;
    Detector *detector;
};

#endif // CVMAINWINDOW_H

