#ifndef CVPBAS_HPP
#define CVPBAS_HPP

#include <opencv2/opencv.hpp>
#include <QThread>

class cvPBAS
{
public:
    cvPBAS(void);
    ~cvPBAS(void);
    bool process(cv::Mat* input, cv::Mat* output);

private:
    void calculateFeatures(std::vector<cv::Mat>* feature, cv::Mat* inputImage);
    void checkValid(int *x, int *y);
    void decisionThresholdRegulator(float* pt, float* meanDistArr);
    void learningRateRegulator(float* pt, float* meanDist,uchar* isFore);
    void init(cv::Mat*);
    void newInitialization();

    cv::Mat meanMinDist;
    float* meanMinDist_Pt;



    int width, height;
    int chans;
    double alpha, beta;
    double formerMeanNorm;
    int foregroundValue, backgroundValue;
    cv::RNG randomGenerator;
    long countOfRandomNumb;
    std::vector<int> randomN, randomMinDist, randomX, randomY, randomT, randomTN;
    int runs;
    double T_init;


    cv::Mat* resultMap;
    std::vector<cv::Mat> currentFeatures;

    std::vector<float*> currentFeaturesM_Pt;
    std::vector<uchar*> currentFeaturesC_Pt;
    uchar* resultMap_Pt;

    std::vector<std::vector<float*> >B_Mag_Pts;
    std::vector<std::vector<uchar*> >B_Col_Pts;

    double sumMagnitude;
    double formerMeanMag;
    float formerDistanceBack;
    std::vector<std::vector<cv::Mat> > backgroundModel;
    double R_scale;
    double R_incdec;

    cv::Mat actualR;
    float* actualR_Pt;
    cv::Mat actualT;
    float* actualT_Pt;
    cv::Mat sobelX, sobelY;
};

class cvPBASThread : public QThread
{
public:
    void setInputMatrix(cv::Mat *input)
    {
        this->input = input;
    }

    cv::Mat getOutputMatrix() const
    {
       return output;
    }

    cvPBASThread() : pbasAlgObj(cvPBAS()) , input(NULL)
    {
    }

  private:
    cv::Mat *input,output;
    cvPBAS pbasAlgObj;
    void run()
    {
       pbasAlgObj.process(input,&output);
    }
};


#endif // CVPBAS_HPP
